package gov.va.med.domain.service.messaging.parse;

import ca.uhn.hl7v2.HL7Exception;

/**
 * Just rethrows the exception rather than allowing processing to continue. This is provided 
 * to revert behavior back to that of the HAPI PipeParser. 
 * 
 * @author Joel Goldberg
 * @version $Id: DefaultHL7ParseErrorListener.java,v 1.4 2005/06/28 12:32:15 joel.goldberg Exp $
 * @since MHV 2.0 <br>Jun 20, 2005
 */
public class DefaultHL7ParseErrorListener 
	implements IHL7ParseErrorListener 
{

    public DefaultHL7ParseErrorListener() {
        super();   
    }

    /**
     *  
     * @see gov.va.med.domain.service.messaging.parse.IHL7ParseErrorListener#onParseSegmentException(HL7ParseSegmentError obj)
     */
    public void onParseSegmentException(HL7ParseSegmentError error) throws HL7Exception {
        throw error.getHL7Exception();
    }

    /**
     *  
     * @see gov.va.med.domain.service.messaging.parse.IHL7ParseErrorListener#onParseFieldException(HL7ParseFieldError obj)
     */
    public void onParseFieldException(HL7ParseFieldError error) throws HL7Exception {
        throw error.getHL7Exception();
    }


    public void onDecoderDataError(HL7DecoderDataError error) throws HL7Exception {
        if (error.getException().getClass().isAssignableFrom(HL7Exception.class)) {
           throw (HL7Exception)error.getException();
        }
        throw new HL7Exception(error.getException());

    }
}
